/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.gif;

import com.sun.media.imageioimpl.plugins.gif.GIFMetadata;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

class GIFWritableStreamMetadata
extends GIFMetadata {
    static final String NATIVE_FORMAT_NAME = "javax_imageio_gif_stream_1.0";
    public static final String[] versionStrings;
    public String version;
    public int logicalScreenWidth;
    public int logicalScreenHeight;
    public int colorResolution;
    public int pixelAspectRatio;
    public int backgroundColorIndex;
    public boolean sortFlag;
    public static final String[] colorTableSizes;
    public byte[] globalColorTable = null;

    GIFWritableStreamMetadata() {
        super(true, NATIVE_FORMAT_NAME, "com.sun.imageio.plugins.gif.GIFStreamMetadataFormat", null, null);
    }

    public boolean isReadOnly() {
        return false;
    }

    public Node getAsTree(String formatName) {
        if (formatName.equals(this.nativeMetadataFormatName)) {
            return this.getNativeTree();
        }
        if (formatName.equals("javax_imageio_1.0")) {
            return this.getStandardTree();
        }
        throw new IllegalArgumentException("Not a recognized format!");
    }

    private Node getNativeTree() {
        IIOMetadataNode root = new IIOMetadataNode(this.nativeMetadataFormatName);
        IIOMetadataNode node = new IIOMetadataNode("Version");
        node.setAttribute("value", this.version);
        root.appendChild(node);
        node = new IIOMetadataNode("LogicalScreenDescriptor");
        node.setAttribute("logicalScreenWidth", Integer.toString(this.logicalScreenWidth));
        node.setAttribute("logicalScreenHeight", Integer.toString(this.logicalScreenHeight));
        node.setAttribute("colorResolution", Integer.toString(this.colorResolution));
        node.setAttribute("pixelAspectRatio", Integer.toString(this.pixelAspectRatio));
        root.appendChild(node);
        if (this.globalColorTable != null) {
            node = new IIOMetadataNode("GlobalColorTable");
            int numEntries = this.globalColorTable.length / 3;
            node.setAttribute("sizeOfGlobalColorTable", Integer.toString(numEntries));
            node.setAttribute("backgroundColorIndex", Integer.toString(this.backgroundColorIndex));
            node.setAttribute("sortFlag", this.sortFlag ? "TRUE" : "FALSE");
            int i = 0;
            while (i < numEntries) {
                IIOMetadataNode entry = new IIOMetadataNode("ColorTableEntry");
                entry.setAttribute("index", Integer.toString(i));
                int r = this.globalColorTable[3 * i] & 0xFF;
                int g = this.globalColorTable[3 * i + 1] & 0xFF;
                int b = this.globalColorTable[3 * i + 2] & 0xFF;
                entry.setAttribute("red", Integer.toString(r));
                entry.setAttribute("green", Integer.toString(g));
                entry.setAttribute("blue", Integer.toString(b));
                node.appendChild(entry);
                ++i;
            }
            root.appendChild(node);
        }
        return root;
    }

    public IIOMetadataNode getStandardChromaNode() {
        IIOMetadataNode chroma_node = new IIOMetadataNode("Chroma");
        IIOMetadataNode node = null;
        node = new IIOMetadataNode("ColorSpaceType");
        node.setAttribute("name", "RGB");
        chroma_node.appendChild(node);
        node = new IIOMetadataNode("BlackIsZero");
        node.setAttribute("value", "TRUE");
        chroma_node.appendChild(node);
        if (this.globalColorTable != null) {
            node = new IIOMetadataNode("Palette");
            int numEntries = this.globalColorTable.length / 3;
            int i = 0;
            while (i < numEntries) {
                IIOMetadataNode entry = new IIOMetadataNode("PaletteEntry");
                entry.setAttribute("index", Integer.toString(i));
                entry.setAttribute("red", Integer.toString(this.globalColorTable[3 * i] & 0xFF));
                entry.setAttribute("green", Integer.toString(this.globalColorTable[3 * i + 1] & 0xFF));
                entry.setAttribute("blue", Integer.toString(this.globalColorTable[3 * i + 2] & 0xFF));
                node.appendChild(entry);
                ++i;
            }
            chroma_node.appendChild(node);
            node = new IIOMetadataNode("BackgroundIndex");
            node.setAttribute("value", Integer.toString(this.backgroundColorIndex));
            chroma_node.appendChild(node);
        }
        return chroma_node;
    }

    public IIOMetadataNode getStandardCompressionNode() {
        IIOMetadataNode compression_node = new IIOMetadataNode("Compression");
        IIOMetadataNode node = null;
        node = new IIOMetadataNode("CompressionTypeName");
        node.setAttribute("value", "lzw");
        compression_node.appendChild(node);
        node = new IIOMetadataNode("Lossless");
        node.setAttribute("value", "true");
        compression_node.appendChild(node);
        return compression_node;
    }

    public IIOMetadataNode getStandardDataNode() {
        IIOMetadataNode data_node = new IIOMetadataNode("Data");
        IIOMetadataNode node = null;
        node = new IIOMetadataNode("SampleFormat");
        node.setAttribute("value", "Index");
        data_node.appendChild(node);
        node = new IIOMetadataNode("BitsPerSample");
        node.setAttribute("value", Integer.toString(this.colorResolution));
        data_node.appendChild(node);
        return data_node;
    }

    public IIOMetadataNode getStandardDimensionNode() {
        IIOMetadataNode dimension_node = new IIOMetadataNode("Dimension");
        IIOMetadataNode node = null;
        node = new IIOMetadataNode("PixelAspectRatio");
        float aspectRatio = 1.0f;
        if (this.pixelAspectRatio != 0) {
            aspectRatio = (float)(this.pixelAspectRatio + 15) / 64.0f;
        }
        node.setAttribute("value", Float.toString(aspectRatio));
        dimension_node.appendChild(node);
        node = new IIOMetadataNode("ImageOrientation");
        node.setAttribute("value", "Normal");
        dimension_node.appendChild(node);
        node = new IIOMetadataNode("HorizontalScreenSize");
        node.setAttribute("value", Integer.toString(this.logicalScreenWidth));
        dimension_node.appendChild(node);
        node = new IIOMetadataNode("VerticalScreenSize");
        node.setAttribute("value", Integer.toString(this.logicalScreenHeight));
        dimension_node.appendChild(node);
        return dimension_node;
    }

    public IIOMetadataNode getStandardDocumentNode() {
        IIOMetadataNode document_node = new IIOMetadataNode("Document");
        IIOMetadataNode node = null;
        node = new IIOMetadataNode("FormatVersion");
        node.setAttribute("value", this.version);
        document_node.appendChild(node);
        return document_node;
    }

    public IIOMetadataNode getStandardTextNode() {
        return null;
    }

    public IIOMetadataNode getStandardTransparencyNode() {
        return null;
    }

    public void mergeTree(String formatName, Node root) throws IIOInvalidTreeException {
        if (formatName.equals(this.nativeMetadataFormatName)) {
            if (root == null) {
                throw new IllegalArgumentException("root == null!");
            }
            this.mergeNativeTree(root);
        } else if (formatName.equals("javax_imageio_1.0")) {
            if (root == null) {
                throw new IllegalArgumentException("root == null!");
            }
            this.mergeStandardTree(root);
        } else {
            throw new IllegalArgumentException("Not a recognized format!");
        }
    }

    public void reset() {
        this.version = null;
        this.logicalScreenWidth = 0;
        this.logicalScreenHeight = 0;
        this.colorResolution = 0;
        this.pixelAspectRatio = 0;
        this.backgroundColorIndex = 0;
        this.sortFlag = false;
        this.globalColorTable = null;
    }

    protected void mergeNativeTree(Node root) throws IIOInvalidTreeException {
        Node node = root;
        if (!node.getNodeName().equals(this.nativeMetadataFormatName)) {
            GIFMetadata.fatal(node, "Root must be " + this.nativeMetadataFormatName);
        }
        node = node.getFirstChild();
        while (node != null) {
            String name = node.getNodeName();
            if (name.equals("Version")) {
                this.version = GIFMetadata.getStringAttribute(node, "value", null, true, versionStrings);
            } else if (name.equals("LogicalScreenDescriptor")) {
                this.logicalScreenWidth = GIFMetadata.getIntAttribute(node, "logicalScreenWidth", -1, true, true, 1, 65535);
                this.logicalScreenHeight = GIFMetadata.getIntAttribute(node, "logicalScreenHeight", -1, true, true, 1, 65535);
                this.colorResolution = GIFMetadata.getIntAttribute(node, "colorResolution", -1, true, true, 1, 8);
                this.pixelAspectRatio = GIFMetadata.getIntAttribute(node, "pixelAspectRatio", -1, true, true, 0, 255);
            } else if (name.equals("GlobalColorTable")) {
                int sizeOfGlobalColorTable = GIFMetadata.getIntAttribute(node, "sizeOfGlobalColorTable", true, 2, 256);
                if (sizeOfGlobalColorTable != 2 && sizeOfGlobalColorTable != 4 && sizeOfGlobalColorTable != 8 && sizeOfGlobalColorTable != 16 && sizeOfGlobalColorTable != 32 && sizeOfGlobalColorTable != 64 && sizeOfGlobalColorTable != 128 && sizeOfGlobalColorTable != 256) {
                    GIFMetadata.fatal(node, "Bad value for GlobalColorTable attribute sizeOfGlobalColorTable!");
                }
                this.backgroundColorIndex = GIFMetadata.getIntAttribute(node, "backgroundColorIndex", -1, true, true, 0, 255);
                this.sortFlag = GIFMetadata.getBooleanAttribute(node, "sortFlag", false, true);
                this.globalColorTable = this.getColorTable(node, "ColorTableEntry", true, sizeOfGlobalColorTable);
            } else {
                GIFMetadata.fatal(node, "Unknown child of root node!");
            }
            node = node.getNextSibling();
        }
    }

    protected void mergeStandardTree(Node root) throws IIOInvalidTreeException {
        Node node = root;
        if (!node.getNodeName().equals("javax_imageio_1.0")) {
            GIFMetadata.fatal(node, "Root must be javax_imageio_1.0");
        }
        node = node.getFirstChild();
        while (node != null) {
            block27: {
                String childName;
                Node childNode;
                String name = node.getNodeName();
                if (name.equals("Chroma")) {
                    childNode = node.getFirstChild();
                    while (childNode != null) {
                        childName = childNode.getNodeName();
                        if (childName.equals("Palette")) {
                            this.globalColorTable = this.getColorTable(childNode, "PaletteEntry", false, -1);
                        } else if (childName.equals("BackgroundIndex")) {
                            this.backgroundColorIndex = GIFMetadata.getIntAttribute(childNode, "value", -1, true, true, 0, 255);
                        }
                        childNode = childNode.getNextSibling();
                    }
                } else if (name.equals("Data")) {
                    childNode = node.getFirstChild();
                    while (childNode != null) {
                        childName = childNode.getNodeName();
                        if (childName.equals("BitsPerSample")) {
                            this.colorResolution = GIFMetadata.getIntAttribute(childNode, "value", -1, true, true, 1, 8);
                            break;
                        }
                        childNode = childNode.getNextSibling();
                    }
                } else if (name.equals("Dimension")) {
                    childNode = node.getFirstChild();
                    while (childNode != null) {
                        childName = childNode.getNodeName();
                        if (childName.equals("PixelAspectRatio")) {
                            float aspectRatio = GIFMetadata.getFloatAttribute(childNode, "value");
                            if (aspectRatio == 1.0f) {
                                this.pixelAspectRatio = 0;
                            } else {
                                int ratio = (int)(aspectRatio * 64.0f - 15.0f);
                                this.pixelAspectRatio = Math.max(Math.min(ratio, 255), 0);
                            }
                        } else if (childName.equals("HorizontalScreenSize")) {
                            this.logicalScreenWidth = GIFMetadata.getIntAttribute(childNode, "value", -1, true, true, 1, 65535);
                        } else if (childName.equals("VerticalScreenSize")) {
                            this.logicalScreenHeight = GIFMetadata.getIntAttribute(childNode, "value", -1, true, true, 1, 65535);
                        }
                        childNode = childNode.getNextSibling();
                    }
                } else if (name.equals("Document")) {
                    childNode = node.getFirstChild();
                    while (childNode != null) {
                        childName = childNode.getNodeName();
                        if (childName.equals("FormatVersion")) {
                            String formatVersion = GIFMetadata.getStringAttribute(childNode, "value", null, true, null);
                            int i = 0;
                            while (i < versionStrings.length) {
                                if (formatVersion.equals(versionStrings[i])) {
                                    this.version = formatVersion;
                                    break block27;
                                }
                                ++i;
                            }
                            break;
                        }
                        childNode = childNode.getNextSibling();
                    }
                }
            }
            node = node.getNextSibling();
        }
    }

    static {
        NATIVE_FORMAT_NAME = NATIVE_FORMAT_NAME;
        versionStrings = new String[]{"87a", "89a"};
        colorTableSizes = new String[]{"2", "4", "8", "16", "32", "64", "128", "256"};
    }
}

